% Inverse lifting biorthogonal wavelet  transform
function x=BW_synth(wc, Par, Ll,pol_dis_qint)
% x--  output signal of  size [ve,2^J]
%wc-- wavelet coefficients
% Ll-- number of decomp. levels
% pol_dis_qint=1--polynom. interp. spline; =2--discr. interp. spline; =3--quasi-interp. spline 
%Par=33 --extended quadratic quasiinterp. spline
% Par --order of  spline

   q=sqrt(2);%q=1;
[~, lwc]=size(wc); J=log2(lwc);
x=zeros(size(wc));
wce=wc(:,1:2^(J-Ll));

fxe=fft(wce,[],2);
for j=Ll:-1:1
jj=J-j;
wco=wc(:,(2^(jj)+1):2^(jj+1));
fxo=fft(wco,[],2);
[fxe]=up_lif(fxe/q,fxo*q,Par,pol_dis_qint);
end
x=real(ifft(fxe,[],2));



% Copyright (c) 2013. Valery A. Zheludev