% Inverse 2D lifting biorthogonal wavelet  transform
function y=BW_synth_2D(z, Par, Ll, pol_dis_qint)
% y--  output signal of  size [2^J,2^J]
%z-- wavelet coefficients
% Ll-- number of decomp. levels
% pol_dis_qint=1--polynom. interp. spline; =2--discr. interp. spline; =3--quasi-interp. spline 
%Par=33 --extended quadratic quasiinterp. spline
% Par --order of  spline
   q=sqrt(2);%^PD;
   
[~, ho]=size(z); J=log2(ho);

cs=1:2^(J-Ll);
y=fft2(z(cs,cs));
   for kk=Ll:-1:1
      y=surqua(y,z);
      [a11, fa12,fa21, fa22]=quartB(y);
 a12= fft2(fa12);    
 a22= fft2(fa22); 
 a21= fft2(fa21); 

 fxe=[a11;a21]/q;fxo=[ a12;  a22]*q;
 y=up_lif(fxe,fxo,Par,pol_dis_qint)';
 [a11, a12,a21, a22]=quartB(y);
 fxe=[a11;a21]/q;fxo=[ a12;  a22]*q;
 y=up_lif(fxe,fxo,Par,pol_dis_qint)';
end
y=real(ifft2(y));
 


% Copyright (c) 2013. Valery A. Zheludev