%Block_runP
%The program implements the 2D  block-based  inversion of the heat equation  and the deconvolution
%in an interactive mode
% and compares  results with the results from the global Tikhonov
% algorithm
%--------------------------- Load Parameters ----------------------------------


params = loadParametersB_P();

imageFileName = params{1};
levels = str2double(params{4});
no_iter = str2double(params{5});

num_blocks =str2double(params{11});
ToX= 0.0000000000000001;
if params{10}=='bp';%Block Pursuit algorithm
    BbP =1;

elseif params{10}=='bb';%Best Basis  algorithm
    BbP =0;
end
if params{3}=='co';%deconvolution
    conv_heat =1;
elseif params{3}=='dh';%inversion of the heat equation (difference approximation)
    conv_heat =2;
elseif params{3}=='ch';%inversion of the heat equation (collocation approximation)
    conv_heat =2;
end

range_rho = [0 500000000];%str2num(params{7}); %range for automatic derivation of the regularization parameter
time_param = str2double(params{6});

noiseFactor = str2double(params{7});% STD of Gaussian noise

kern_ord = 2;%order of the spline, which interplates the convolution kernel
rhoScale = str2double(params{8}); %  optional scaling  the automaticall derived regularization parameter
Par = str2double(params{2});  % wavelet packet's order;

changeNoise = params{9};

%preparation of the orinal image 'f', noised blurred input 'z', blurring
% DFT of the kernel 'fker' and additive noise
[f, z,  fker, noise] = buildInputFunctions_BP( changeNoise, noiseFactor, time_param,  imageFileName,conv_heat,Par);
%
[N,hf]=size(f);
%preparation of auxiliary  coefficients to be used in the global and block-wise Tikhonov
%solutions
[W,T,V]=weteviP(Par, kern_ord,N,conv_heat,hf);
%figure;imshow(f, [min(f(:)) max(f(:))]);
[PSNR]=psnB(f, z);
ttl = ['input, PSNR= ' num2str(PSNR)];
%
fZ=fft2(z);
figure;aj(z);title(ttl)
set(gca,'YTick',0:256:512);set(gca,'YTickLabel',{})
set(gca,'XTick',0:256:512);set(gca,'XTickLabel', {})

[N,~]=size(z);



ee=sum(noise(:).^2);
%Deriving the optimal regularization parameter for global Tikhonov solution
if ee==0
 rho_coarse =.000000000001; 
else
rho_coarse  =defro_PN(fZ,fker,ee,W,T,range_rho,ToX)

end
%global Tikhonov solution
[decon y] = tikh_dec(fZ,fker,rho_coarse,W,T,V);
[PSNRt, mablod]=psnB(f, decon);
decon1=decon.*(decon>=0).*(decon<255)+255*(decon>255);%figure;aii(decon)
[PSNRtt, mablod]=psnB(f, decon1);
   
figure;aj(decon1);title(['Tikhonov, PSNR: ' num2str(PSNRtt)  ', rho: '  num2str(rho_coarse)]);
set(gca,'YTick',0:256:512);set(gca,'YTickLabel',{})
set(gca,'XTick',0:256:512);set(gca,'XTickLabel', {})


tic
if BbP==1
%Block Pursuit solution
thresh_detP %setting threshold
[result,remainder,fin_numb_iteration] = deconExecute_BbpP(Par, kern_ord, z, f, fker, noise,levels,rhoScale,no_iter,conv_heat,num_blocks,tre);
else
    %Best Basis solution
[result,fin_numb_iteration]=deconExecute_BbbP(Par, kern_ord, z, f, fker, noise,levels,rhoScale,no_iter,conv_heat);

end
toc
result2=result.*(result>=0).*(result<255)+255*(result>255);%figure;aii(decwin)

%figure;imshow(result, [min(result(:)) max(result(:))]);title(['PSNR=' num2str(PSNR) '; ' int2str(fin_numb_iteration) ' iterations']) ;
[PSNR ]=psnB(f, result2);
figure;aj(result2);title(['PSNR=' num2str(PSNR) '; ' int2str(fin_numb_iteration) ' iterations']) ;
set(gca,'YTick',0:256:512);set(gca,'YTickLabel',{})
set(gca,'XTick',0:256:512);set(gca,'XTickLabel', {})

% Copyright (c) 2013. Valery A. Zheludev 