function [result,fin_no_it] = deconExecute_BbbP(Par, kern_ord, z, f, fker, noise,lev,sc,no_iter,conv_heat)
%Block based Best Basis processing
% Par --spline order 
%kern_ord-- order of the spline interpolating the blurring kernel. 
%For heat eq. kern_ord=0, for deconv. typically kern_ord=2
%z-- blurred noised input
%f-- original (used for monitorng the restoration process, not participates
% in processing)
%fker--DFT of the blurring kernel
%noise--modelled noise
%lev -- decomposition depth
%sc-- scaling of the regularization parameter
%no_iter --maximal number of iterations
%conv_heat=1--deconv.;conv_heat=2--heat inversion with difference appr.;
%conv_heat=3--inversion with collocation appr.;
%result -- result of processing
%fin_no_it final number of iterations
[N,hz]=size(z);
%calculation of SHA spectra of wavelet packets
[Depth,w_coef ]=wavs_coefP(Par,N);
w_coef=w_coef(2:end,:);
levels=min(lev,Depth);
result = zeros(N, N);

count = no_iter;
sb=[0 0 0];
SB=[];

%Wavelet packet transform of the input
[~, ~, entro,ener]=spl_WP_anaP2D(z,Par,levels);
ListBB=WP_BB_Listree2D_P(entro,ener);

% if noDecon
%     lis =ListBB;
% else
 
 lis=sort_list_P(ListBB,fker,w_coef);
%end
 
 [vli, ~]=size(lis);
 %Reduction of the Best Basis list
 figure;bar(1:vli,lis(:,end));title('Norms of wavelet packets convolved with kernel') 
 
 tre1=input('Define number of waveforms to be retained;0--former; -?')
 if tre1~=0
     
     tre=tre1;
     if length(tre)==1;
         tre=[1: tre];
     end
  save TRE tre   
 else load TRE
 end
 
 lis=lis(tre,:);
 close
 result=zeros(N,N);
 SB=[];
 fZ = fft2(z);
 fNoise = fft2(noise);

  [vli, ~]=size(lis);
  [W,T,V]=weteviP(Par, kern_ord,N,conv_heat,hz);%auxiliary parameters
 for kk = 1 : min(count,vli)%iterations


    maxPos = lis(kk,1:3);
   
    % partial solution in a subspace 
    [ sp_f, ~, rho, max_norm_conv_wp] = onePacketDecon_PN(maxPos,   fker, w_coef, fZ, fNoise,sc,W,T,V);
   
   result = result + sp_f;  
    
    %[PSNR mablod]=psn(f, sp_f);
   [PSNR,~]=psnB(f, result);
    %sub_block = ['{' num2str(r) ',' num2str(mr) ',' num2str(mc) '}'];   
    sub_block = num2str(maxPos)   
   
    sub_b = maxPos;  
    %SB=[SB;sb];
   SB=[SB;sub_b];
    
    %SB
    ttl = ['intermediate result, step  ' num2str(kk) ',  ' sub_block  ', PSNR= ' num2str(PSNR) ' rho ' num2str(rho) '; a=' num2str(max_norm_conv_wp) ]

 end

fin_no_it=kk;
SB
end

% Copyright (c) 2013. Valery A. Zheludev 