function [uk1,dk1,bk1]=BREGMAN_INPAINT_DEBLU_hm_1d(IND_noise,r1,dk,bk,ker,Ll,IND,mu,lambda,iter_c_grad,HMWF)
%a single Bregman iteration for the restoration of a row signal corrupted by
%blurring, addition of white noise and loss of a iter_c_grader of pixels
%IND_noise -- indices of missing pixels
% IND-- index of frame from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- iter_c_grader of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%mu,lambda-- parameters
%Ll-- depth of decomposition
%ker -- blurring kernel
%dk,bk -- auxiliary input  cell arrays 
%dk1,bk1 -- auxiliary output  cell arrays 
%HMWF -- cell array of the transform filters (produced by function 'hmwf.m')
%iter_c_grad number of the cohj. gradient iterations
%r1-- data array convolved with the conjugate kernel
%uk1 -- result of the Bregman iteration
DB=framinPb_1d(dk,bk,-1);
r2=fram34_rec_hmwf(DB,Ll,IND,HMWF);



uk2=r1+mu*r2;

%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%conjugate gradient (CG) method
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

 uk1  = conjgradBP_1d(ker,IND_noise,mu,uk2,zeros(size(uk2)),iter_c_grad); 
 

vv1=fram34_dec_hmwf(uk1,Ll,IND,HMWF);

fx=lambda/mu;

dk1=fram_threPb_1d(framinPb_1d(vv1,bk,1),fx );

vk=framinPb_1d(vv1,dk1,-1); 

bk1=framinPb_1d(bk,vk,1); 

