function [G,fG]=buikerP(vc,t,sg)
%modeling  kernels for 2D convolution and the heat equation
%[vc,vc]-- size of the 2D signal to be convolved
%t--STD for Gaussian kernel, evolution time for the heat equation
%sg=1 -- Gaussian kernel
%sg=5 -- the heat equation
if t==0
   G=zeros(vc,vc);
   G(1,1)=1;
else
    if sg==1
       G = fspecial('gaussian',vc,t);G=double(G);
    
    
       elseif sg==5%heat equation 

wv=zeros(1,vc);

nv=0:(vc-1);
nh=0:(vc-1);
wv=2*sin(pi*nv/vc)';
wv=repmat(wv.^2,1,vc);

G=real(ifft2(exp(-t*(wv+wv'))));
    end

    if sg~=5
       % G=circshift(G,[vc/2-1,vc/2-1]);
    G=circshift(G,[vc/2,vc/2]);
    end
    end
     fG=fft2(G);
   
   
     