%
function [spli]=heatsplaP2(x,Par,eta,Ll,rho) 
%inverse of 2D heat inversion
%x --values of the input array at integer points {k,n=0:N-1}, N=2^j
%Par order of spline, should be even number
%Ll -- depth of subdivision
%calculation of the 2D spline values 'spli'at dyadic rational grid {k/2^Ll,n/2^Ll}
% eta--kernel coefficients for 2D heat inversion

%rho -- regularization parameter
[lx,N]=size(x);
Y=fft2(x);
 
 [u,~]=juviP(Par,N);
[u2,~]=juviP(Par*2,N);

n=0:lx-1;
   s=(2*sin(pi*n/lx)).^Par;
  %s2=(2*sin(pi*(0:N-1)/N)).^(2); 
  M1=s'*u2;
M2=u'*(u.^2);
M=M1./(M2+eps);


  W2=M'+M;
  RH=Y.*conj(eta);
  
    x=real(ifft2(RH./(eps+rho*W2+abs(eta.^2))));
 if Ll>0   
  
[spli]=intersplli2DPt(x,2,Par,Ll,2,Par,Ll);
 else
     spli=x;
     gri=1:lx;
 end

fspli=abs(fft2(spli));
 %



% % Copyright (c) 2011. Valery A. Zheludev
% 



