function [GS,TS]=D_wP_theta_coefP(Par,N,De,fker)

%N- length of period
%Par- order of spline
%fker- DFT of kernel 
%De- maximal depth of decomposition
%preparation of DFT spectra of discrete spline wavelet packets  of order Par on the fragment
%of length N down to the level De and DFT of wavelet packets convolved with
%the kernel `ker`, whose DFT is `fker'
%GS- cell array of DFT spectra coefficients of discrete  wavelet packets
%TS- cell array of DFT spectra coefficients of the convolved discrete  wavelet packets



GS=cell(De,1);

GS{1}=cell(1,2);
TS=cell(De,1);

TS{1}=cell(1,2);

[S D ]= D_lohifilP(Par,N,1);
GS{1}{1}=S*sqrt(2);  
GS{1}{2}=D*sqrt(2); 
TS{1}{1}=S*sqrt(2).*fker;  
TS{1}{2}=D*sqrt(2).*fker;  


for d=2:De 
    dd=2^d; 
    
   GS{d}=cell(1,dd);
   TS{d}=cell(1,dd);
    
   [S D ]= D_lohifilP(Par,N,d);
       
	
      
    for b=0:(dd-1)
        bb=floor(b/2);  
        rr=rem(bb,2);  
        us=GS{d-1}{bb+1};
        a0=us.*(rr*S+(1-rr)*D)*sqrt(2);
        a1=us.*(rr*D+(1-rr)*S)*sqrt(2); 
        GS{d}{2*bb+2}=a0; 
        GS{d}{2*bb+1}=a1;
   TS{d}{2*bb+2}=a0.*fker;   
        TS{d}{2*bb+1}=a1.*fker;  
   
    end
end

% Copyright (c) 2013. Valery A. Zheludev
 