function [wvtran, wctran, entro,ener]=D_WP_anal_2DP(x,Par,DeTr)
%2D discrete spline wavelet packet analysis of an array `x 
%Par order of discrete spline
%DeTr depth of decomposition
%x--input array
%wvtran --cell array of size (DeTr+1,1),where  cell #l (l=1:DeTr+1)contains the 
%coordinates in the wavelet packet basis from the level 'l-1', which are arranged according to their
%frequency content

%wctran -- cell array of size (DeTr+1,1),where  cell #l (l=1:DeTr+1)contains the coordinates
%in the wavelet packet basis  from the level 'l-1', where each block of coordinates
%occupies a separate subcell. Altogether cell #l comprizes 4^(l-1) subcells, which are labeled according to the  
%frequency content of the coefficients

% entro -- cell array of size (DeTr+1,1),where  cell #l (l=1:DeTr+1)contains the entropies in  4^(l-1)blocks 
%of coordinates from the level 'l-1'
% ener -- cell array of size (DeTr+1,1),where  cell #l (l=1:DeTr+1)contains the l2 norms of  4^(l-1)blocks 
%of coordinates from the level 'l-1'


[vx ,M]=size(x);
ny=sqrt(sum(x(:).^2));
fx=fft2(x);
wvtran=cell(DeTr+1,1);
entro=cell(DeTr+1,1);
ener=cell(DeTr+1,1);
wctran=cell(DeTr+1,1);
wctran{1}=x;
wvtran{1}=x;
entro{1}=caenP(x,1,ny);
ener{1}=ny;


MM=M;

for kk=1:DeTr
 A= D_matr_transP(MM,Par,vx,kk,1);    
   
    %A=matr_trans(M,Par,MM,BSUV,1);
   [wvt, wct, fwvt,ent, ene]=wP_down_2DP(kk,M,fx,A,ny); 

  fx=fwvt;
  M=M/2;
 wvtran{kk+1}= wvt;
 entro{kk+1}= ent;
 ener{kk+1}= ene;
  wctran{kk+1}= wct;
 % fwvtran{kk+1}= fwvt;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%
