function [Ha,Hs, Ma,  Ms ] = HM4_P( Par,TS,N,lv)
%preparation of  filters for one step of a 4-channel frame transform
%lv--number of row signals of length 'N' to be transformed

% Par-- spline order; 
%TS=0--tight frame, otherwise -- semi-tight frame
sq=sqrt(2);

n=0:(N-1);
w=exp(2*pi*i*n/N);
wm=exp(-2*pi*i*n/N);


if Par==1%linear spline
    F=(1+w.^1)/2;
    [Ha,Hs]=hahs_i(F,lv);
A=(1-w.^1)/4;
  [Ma,Ms]=mams(A,lv); 
  

elseif Par==2%quadratic interp. spline
     U=w.^1+6+wm.^1;
    F=4*(1+w)./U;
   [Ha,Hs]=hahs_i(F,lv);
  
if TS==0
    A=(w-2+wm)./U/2; 
   [Ma,Ms]=mams(A,lv); 
   elseif TS==1%antisymmetric factorization
  
 Ta=(wm.^2-3*wm+3-w)./U/2;
 Ts=(1-w)./U*2;

[Ma,Ms]=mams_t(Ta/sq,Ts/sq,lv);

end
%%%%%%%%%%%%%%%%%

   
   elseif Par==3%cubic interp. spline
    q=7-4*sqrt(3);
    U= w.^1+4+wm.^1;   
  F=(w.^2+23*w.^1+23+wm.^1)/8./U;
  [Ha,Hs]=hahs_i(F,lv); 
G= -w.^1+14-wm.^1;   
  if TS==0%non-symmetric  factorization
      A=(w.^1-2+wm.^1)/16./U.*( 1-q*w.^1)/sqrt(q);
  [Ma,Ms]=mams(A,lv);
 elseif TS==1%symmetric IIR factorization
    Ta=(w.^1-2+wm.^1)./U/2;
 Ts=(w.^1-2+wm.^1)/32.*G./U;
[Ma,Ms]=mams_t(Ta/sq,Ts/sq,lv);
  
  elseif TS==2%antisymmetric IIR factorization
  
      
    Ta=(wm.^2-3*wm+3-w)./U/4*sq;
 Ts=(1-w)/16.*G./U/sq;
  
 [Ma,Ms]=mams_t(Ta/sq,Ts/sq,lv);
  end 
  elseif Par==4% interp. spline of fourth degree
    q=49 - 20*6^(1/2);
U= w.^2+wm.^2+76*(w+wm)+230;   
G= -w.^1+98-wm.^1;   
  F=(w.^2+11*w.^1+11+wm.^1)*16./U;
  [Ha,Hs]=hahs_i(F,lv);
  if TS==0%non-symmetric  factorization
      A=(w.^1-3+3*wm.^1-wm.^2)./U.*( 1-q*w.^1)/sqrt(q)/2;
      [Ma,Ms]=mams(A,lv);

  elseif TS==1%symmetric IIR factorization
    Ta=(w.^2+6+wm.^2 -4*(w.^1+wm.^1))./U*4*sq;
 Ts=-(w.^1-2+wm.^1).*G./U/4/sq;
 [Ma,Ms]=mams_t(Ta/sq,Ts/sq,lv);   

   elseif TS==2%antisymmetric IIR factorization
 Ts=(w.^1-3+3*wm.^1-wm.^2)./U.*G/4*1/2/sq;
   Ta=(wm.^1-3+3*w.^1-w.^2)./U*4/1*2*sq;;
 [Ma,Ms]=mams_t(Ta/sq,Ts/sq,lv);   
  end 

  elseif Par==5%quadratic  quasiinterp. spline (interp. low-pass filter)
    q=7-4*sqrt(3);
  
G= -w.^1+14-wm.^1;   
  F=(-w.^2+9*w.^1+9-wm.^1)/16;
 [Ha,Hs]=hahs_i(F,lv);
  if TS==0%non-symmetric  factorization
%       Tm2=(w.^1-2+wm.^1)/16.*( 1-q*wm.^1)/sqrt(q);
%    T3=-Tm2;
 A=(w.^1-2+wm.^1)/16.*( 1-q*w.^1)/sqrt(q)/2;
 [Ma,Ms]=mams(A,lv);
 %Tm3=-T2;
    elseif TS==1%symmetric  factorization
  Ta=(w.^1-2+wm.^1)/4;
 
  Ts=(w.^1-2+wm.^1).*G/64; 
  [Ma,Ms]=mams_t(Ta/sq,Ts/sq,lv);

     elseif TS==2%antisymmetric factorization
  
 Ta=(wm.^2-3*wm+3-w)/8;
 Ts=(1-w)/32.*G;
 [Ma,Ms]=mams_t(Ta/sq,Ts/sq,lv);

 
  end
    elseif Par==7%quadratic quasiinterp. spline (upgraded)
        F=(3*w.^3-25*w.^2+150*w.^1+150-25*wm.^1+3*wm.^2)/256; 
[Ha,Hs]=hahs_i(F,lv);
 P=9*(w.^2+wm.^2)-96*(w.^1+wm.^1)+814;
      if TS==0
aa= 15^(1/2)*i + ((15^(1/2)*64*i)/3 - 320/9)^(1/2)/2 + 8/3; 
aaa=abs(aa);
b0=1/aaa;
b1=2*real(aa)/aaa;
b2=aaa;  
A=3/256*(1-3*wm+3*wm.^2-wm.^3).*(b0-b1*w+b2*w.^2)/2;
[Ma,Ms]=mams(A,lv);
      elseif TS==1
       Ts=P.*(-wm+2-w)/256/16;
Ta=((w.^2+wm.^2)-4*(w.^1+wm.^1)+6)/256*16; 
[Ma,Ms]=mams_t(Ta/sq,Ts/sq,lv);     

      end  
    elseif Par==8%pseudospline
        Q=-9*(w.^2+wm.^2)-28*(w.^1+wm.^1)+1610; 
G=(110+12*(w+wm)-3*(w.^2+wm.^2))*sq/256;
F=(9*(1+w)-(wm+w.^2))*sq/32;
[Ha,Hs]=hahs_ni(G,F,lv);
if TS==0
q1= 0.084036721311635863751390197446785;
 q2=0.066541718952892961207287011854059;
qq=sqrt(q1*q2);
A=3*(w-2+wm).*(1-q1*w).*(1+q2*w)/qq/256;
[Ma,Ms]=mams(A,lv);
elseif TS==1
   
       Ts=sq*Q.*(-wm+2-w)/256/16/2;
Ta=sq*2*(-wm+2-w)/8/1; 
[Ma,Ms]=mams_t(Ta/sq,Ts/sq,lv);  
elseif TS==2%antisymmetric factorization
     Ta=sq*(wm.^2-3*wm+3-w)/8;
 Ts=sq*2*Q.*(1-w)/256/2/8/2;
[Ma,Ms]=mams_t(Ta/sq,Ts/sq,lv);  
end
elseif Par==6%quadratic quasiint. spline (non-interp. low-pass filter)
G=(58+4*(w+wm)-(w.^2+wm.^2))*sq/128;
F=(9*(1+w)-(wm+w.^2))*sq/32;
[Ha,Hs]=hahs_ni(G,F,lv);
Q=-(w.^2+wm.^2)-12*(w.^1+wm.^1)+346; 
if TS==0
q1=  0.073953753020242364122024941764069;
 q2=0.039128545627548780526469694812049;
qq=sqrt(q1*q2);
A=(w-2+wm).*(1-q1*w).*(1+q2*w)/qq/64/2;
[Ma,Ms]=mams(A,lv);
elseif TS==1%symmetric factorization

      Ts=sq*Q.*(-wm+2-w)/64/2/16;
Ta=sq*(-wm+2-w)/2/2;       
[Ma,Ms]=mams_t(Ta/sq,Ts/sq,lv);    
elseif TS==2%antisymmetric factorization
     Ta=sq*(wm.^2-3*wm+3-w)/8;
 Ts=sq*Q.*(1-w)/64/2/8;
[Ma,Ms]=mams_t(Ta/sq,Ts/sq,lv);  
end
 elseif Par==60%discrete spline of 6-th order
   U=3*w+10+3*wm;
   F=(1+w).*(w.^1+14+wm.^1)./U/2;
[Ha,Hs]=hahs_i(F,lv);
  if TS==0
    A=(wm-3+3*w.^1-w.^2)./U/4;
   [Ma,Ms]=mams(A,lv); 
end
 elseif Par==80%discrete spline of 8-th order
   U=w.^2+28*w+70+wm.^2+28*wm;
   F=8*(1+w).*(w.^1+6+wm.^1)./U;

[Ha,Hs]=hahs_i(F,lv);
  if TS==0
     A=(w-2+wm).^2./U/2;

   [Ma,Ms]=mams(A,lv); 
end
 elseif Par==100%discrete spline of 10-th order
   U=10*w.^2+120*w+252+10*wm.^2+120*wm;
   
   F=(1+w).*(w.^2+44*w+166+44*wm+wm.^2)./U;

[Ha,Hs]=hahs_i(F,lv);
  if TS==0
     A=(w.^3-5*w.^2+10*w-10+5*wm-wm.^2)./U/2;

   [Ma,Ms]=mams(A,lv); 
  end
 elseif Par==120%discrete spline of 12-th order
   U=w.^3+66*w.^2+495*w+924+wm.^3+66*wm.^2+495*wm;
   F=4*(1+w).*(w.^1+14+wm.^1).*(3*w+10+3*wm)./U;

[Ha,Hs]=hahs_i(F,lv);
  if TS==0
      A=(w-2+wm).^3./U/2;


   [Ma,Ms]=mams(A,lv); 
end

end
%%%%%%%%%%%%%%%%%
function [Ha,Hs]=hahs_i(F,lv)
sq=sqrt(2);
      Ha=cell(2,2);
Hs=Ha;
 F=repmat(F/sq,lv,1);
   Fm=conj(F);
   Ha{1,1}=ones(size(F))/sq;Ha{1,2}=Fm;
   Ha{2,1}=-F;Ha{2,2}=ones(size(F))/sq;
    Hs{1,1}=ones(size(F))/sq;Hs{1,2}=-Fm;
   Hs{2,1}=F;Hs{2,2}=ones(size(F))/sq;
   %%%%%%%%%%%%%%%%%
function [Ha,Hs]=hahs_ni(G,F,lv)
sq=sqrt(2);
      Ha=cell(2,2);
Hs=Ha;
 F=repmat(F,lv,1);
   Fm=conj(F);
   G=repmat(G,lv,1);
   Gm=conj(G);
   Ha{1,1}=Gm;Ha{1,2}=Fm;
   Ha{2,1}=-F;Ha{2,2}=G;
    Hs{1,1}=G;Hs{1,2}=-Fm;
   Hs{2,1}=F;Hs{2,2}=Gm;
 %%%%%%%%%%%%%%%%%%%%%%%%%
 function [Ma,Ms]=mams(A,lv)
     Ma=cell(2,2);
Ms=Ma;
 A=repmat(A,lv,1);
   Am=conj(A);
   Ma{1,1}=A;Ma{1,2}=Am;
   Ma{2,1}=-A;Ma{2,2}=Am;
    Ms{1,1}=Am;Ms{1,2}=-Am;
   Ms{2,1}=A;Ms{2,2}=A;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [Ma,Ms]=mams_t(Ta,Ts,lv)

%sq=sqrt(2);
      Ma=cell(2,2);
Ms=Ma;
Ta=repmat(Ta,lv,1);
   Ts=repmat(Ts,lv,1);
   Ma{1,1}=Ta;Ma{1,2}=zeros(size(Ta));
   Ma{2,1}=zeros(size(Ta));Ma{2,2}=-Ts;
    Ms{1,1}=Ts;Ms{1,2}=zeros(size(Ta));
   Ms{2,1}=zeros(size(Ta));Ms{2,2}=-Ta;   
   
   % Copyright (c) 2013. Valery A. Zheludev