function pctran=fram34_dec2d_hm(x,DeTr,IND,pd)
%3 or 4 -channel frame decomposition of a 2D array 'x'
%DeTr-- depth of decomposition
% IND-- index of frame  from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%if pd==-1 -- swap synthesis and analysis band-pass filters

%pctran--cell array of the transform coefficients

if nargin<4
    pd=1;
end 
no_channel=IND(1);

pctran=cell(DeTr,1);

x1=x;
for kk=1:DeTr
    Lev=cell(no_channel,no_channel);
    if no_channel==3
[z1, z2, z3]= fram3_down_hm(x1,IND,pd);
for mm=1:3
    eval(['z=transpose(z' int2str(mm) ');'])
[y1, y2, y3]= fram3_down_hm(z,IND,pd);
eval(['x' int2str(mm) '=transpose(y' int2str(mm) ');'])
%x1=y1';
for nn=1:3
    eval(['Lev{' int2str(nn) ',' int2str(mm) '}=transpose(y' int2str(nn) ');'])
end
end
elseif no_channel==4
[z1, z2, z3, z4]= fram4_down_hm(x1,IND,pd);
for mm=1:4
    eval(['z=transpose(z' int2str(mm) ');'])
[y1, y2, y3, y4]= fram4_down_hm(z,IND,pd);
eval(['x' int2str(mm) '=transpose(y' int2str(mm) ');'])

for nn=1:4
    eval(['Lev{' int2str(nn) ',' int2str(mm) '}=transpose(y' int2str(nn) ');'])
end 

end
end




pctran{kk}=Lev;
end

% Copyright (c) 2013. Valery A. Zheludev