function pctran=fram34_dec2d_hmwf(x,DeTr,IND,HMWF,pd)
%3 or 4 -channel frame decomposition of a 2D array 'x'
%DeTr-- depth of decomposition
% IND-- index of frame from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%HMWF -- cell array of the transform filters (produced by function 'hmwf.m')
%if pd==-1 -- swap synthesis and analysis band-pass filters

%pctran--cell array of the transform coefficients


if nargin<5
    pd=1;
end 
no_channel=IND(1);
[vh, h]=size(x);


pctran=cell(DeTr,1);

x1=x;
for kk=1:DeTr
     hh=HMWF{kk};
 Lev=cell(no_channel,no_channel);
    if no_channel==3
        F=hh{1,1};
    W=hh{1,2};
    if pd==-1
        F=hh{1,3};
    W=hh{1,4}; 
    end
    F=F(1:vh,:);W=W(1:vh,:);
    [z1, z2, z3]= fram3_down_hmwf(x1,F,W);
    vh=vh/2;
F=F(1:vh,:);    W=W(1:vh,:);
for mm=1:3
    eval(['z=transpose(z' int2str(mm) ');'])
[y1, y2, y3]= fram3_down_hmwf(z,F,W);

eval(['x' int2str(mm) '=transpose(y' int2str(mm) ');'])

for nn=1:3
    eval(['Lev{' int2str(nn) ',' int2str(mm) '}=transpose(y' int2str(nn) ');'])
end
end
elseif no_channel==4
    
     H=hh{1,1};
    M=hh{1,3};
if pd==-1
    H=hh{1,2};
    M=hh{1,4};
end
for nv=1:2
 for nh=1:2   
H{nv,nh}=H{nv,nh}(1:vh,:);M{nv,nh}=M{nv,nh}(1:vh,:);
 end
end
[z1, z2, z3, z4]= fram4_down_hmwf(x1,H,M);
vh=vh/2;
for nv=1:2
 for nh=1:2   
H{nv,nh}=H{nv,nh}(1:vh,:);M{nv,nh}=M{nv,nh}(1:vh,:);
 end
end
for mm=1:4
    
    eval(['z=transpose(z' int2str(mm) ');'])
[y1, y2, y3, y4]= fram4_down_hmwf(z,H,M);
eval(['x' int2str(mm) '=transpose(y' int2str(mm) ');'])

for nn=1:4
    eval(['Lev{' int2str(nn) ',' int2str(mm) '}=transpose(y' int2str(nn) ');'])
end 

end

end




pctran{kk}=Lev;
end

% Copyright (c) 2013. Valery A. Zheludev