function x=fram34_rec2d_hmwf(pctran,DeTr,IND,HMWF,pd)
%3 or 4 -channel frame reconstruction of a 2D array 'x'
%pctran--cell array of the transform coefficients
%DeTr-- depth of decomposition
% IND-- index of frame from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%if pd==-1 -- swap synthesis and analysis band-pass filters
%HMWF -- cell array of the transform filters (produced by function 'hmwf.m')

no_channel=IND(1);
if nargin<5
    pd=1;
end 
x=pctran{DeTr}{1,1};
[vh,N]=size(x);
for kk=DeTr:-1:1
     hh=HMWF{kk};
    Lev=pctran{kk};
   if no_channel==3 
        F=hh{1,3};    W=hh{1,4}; 
    if pd==-1
        F=hh{1,1};    W=hh{1,2}; 
    end  
    F1=F(1:vh,:);W1=W(1:vh,:);   
    l=x';h=Lev{2,1}';s=Lev{3,1}';
    L=fram3_up_hmwf(l, h, s,F1,W1)';
  l=Lev{1,2}';h=Lev{2,2}';s=Lev{3,2}';  
  H=fram3_up_hmwf(l, h, s,F1,W1)';
    l=Lev{1,3}';h=Lev{2,3}';s=Lev{3,3}';  
  S=fram3_up_hmwf(l, h, s,F1,W1)';
  vh=2*vh;
 F=F(1:vh,:);W=W(1:vh,:); 
 x= fram3_up_hmwf(L, H, S,F,W);
   elseif no_channel==4
        H=hh{1,2};    M=hh{1,4};    
    if pd==-1
 H=hh{1,1};    M=hh{1,3};
end    
for nv=1:2
 for nh=1:2   
H1{nv,nh}=H{nv,nh}(1:vh,:);M1{nv,nh}=M{nv,nh}(1:vh,:);
 end
end

     l=x';h=Lev{2,1}';s2=Lev{3,1}';s3=Lev{4,1}';
 L=fram4_up_hmwf(l, h, s2,s3,H1,M1)'; 
 
  l=Lev{1,2}';;h=Lev{2,2}';s2=Lev{3,2}';s3=Lev{4,2}';  
  hH=fram4_up_hmwf(l, h, s2,s3,H1,M1)'; 
    l=Lev{1,3}';;h=Lev{2,3}';s2=Lev{3,3}'; s3=Lev{4,3}'; 
  S2=fram4_up_hmwf(l, h, s2,s3,H1,M1)';   
    l=Lev{1,4}';;h=Lev{2,4}';s2=Lev{3,4}'; s3=Lev{4,4}'; 
  S3=fram4_up_hmwf(l, h, s2,s3,H1,M1)'; 
  vh=2*vh;
 for nv=1:2
 for nh=1:2   
H{nv,nh}=H{nv,nh}(1:vh,:);M{nv,nh}=M{nv,nh}(1:vh,:);
 end
end 
 x= fram4_up_hmwf(L, hH, S2,S3,H,M);
end
end

% Copyright (c) 2013. Valery A. Zheludev