function x=fram34_rec_hmwf(pctran,DeTr,IND,HMWF,pd)
%3 or 4 -channel frame reconstruction of a signal or an array of row signals 'x'
%pctran--cell array of the transform coefficients
%DeTr-- depth of decomposition
% IND-- index of frame from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%if pd==-1 -- swap synthesis and analysis band-pass filters
%HMWF -- cell array of the transform filters (produced by function 'hmwf.m')


if nargin<5
    pd=1;
end 
x=pctran{DeTr,1};
[lv,N]=size(x);
no_channel=IND(1);
for kk=DeTr:-1:1
    hh=HMWF{kk};
    if no_channel==3
   F=hh{1,3};
    W=hh{1,4}; 
    if pd==-1
        F=hh{1,1};
    W=hh{1,2}; 
    end     
h=pctran{kk,3};
s=pctran{kk,2};
x= fram3_up_hmwf(x, h, s,F,W);
    elseif  no_channel==4
         H=hh{1,2};
    M=hh{1,4};
   
if pd==-1

 H=hh{1,1};
    M=hh{1,3};
end    
     h=pctran{kk,2};
s2=pctran{kk,3};
s3=pctran{kk,4};
x= fram4_up_hmwf(x, h, s2,s3,H,M);   
[lv,N]=size(x);
    end
end
% Copyright (c) 2013. Valery A. Zheludev