function x= fram4_up_hm(l1, h, s2, s3, IND,pd)
%one step of 4-channel frame reconstruction of a signal or a set of row signals 'x'

% IND-- index of frame from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%if pd==-1 -- swap synthesis and analysis band-pass filters

%l1, h --the low-, high-pass transform coefficients
%s2 and s3--the  band-pass transform coefficients

[lv,N]=size(h);
Par=IND(2);
TS=IND(3);
sq=sqrt(2);

fl=fft(l1,[],2);
fh=fft(h,[],2);
fs2=fft(s2,[],2);
fs3=fft(s3,[],2);

[~,H, ~ , M] = HM4_P( Par,TS,N,lv);
if pd==-1
[H,~, M, ~ ] = HM4_P( Par,TS,N,lv);
end
     fle=fl.*H{1,1}+fh.*H{1,2}+fs2.*M{1,1}+fs3.*M{1,2};
flo=fl.*H{2,1}+fh.*H{2,2}+fs2.*M{2,1}+fs3.*M{2,2};

lo=real(ifft(flo,[],2));
le=real(ifft(fle,[],2));
x=zeros(lv,2*N);
x(:,1:2:end)=le;
x(:,2:2:end)=lo;

% Copyright (c) 2013. Valery A. Zheludev