function HMWF=hmwf(IND,DeTr,lv,N)
%%HMWF -- cell array of the 3 or 4 -channel frame transform filters 
%lv--number of row signals of length 'N' to be transformed
%DeTr-- depth of decomposition
% IND-- index of frame from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
no_channel=IND(1);
Par=IND(2);
TS=IND(3);
HMWF=cell(DeTr,1);

 for kk=1:DeTr
     N=N/2;
     hh=cell(1,4);
     
     if no_channel==3
         
         [Fd,Wd,Fr,Wr]= FW3_P(lv,N, Par,TS);
         hh{1,1}=Fd;
         hh{1,2}=Wd;
         hh{1,3}=Fr;
         hh{1,4}=Wr;
     elseif no_channel==4
         [Ha,Hs, Ma,  Ms ] = HM4_P( Par,TS,N,lv);
         hh{1,1}=Ha;
         hh{1,2}=Hs;
         hh{1,3}=Ma;
         hh{1,4}=Ms;
     end
     HMWF{kk}=hh;
    
 end
 
 % Copyright (c) 2013. Valery A. Zheludev