%RMP_runP

%--------------------------- Load Parameters ----------------------------------

%list_images
params = loadParametersMP_P();

imageFileName = params{1};
levs = str2double(params{4});
levels =1:levs;
no_iter = str2double(params{5});
spl_ord= str2double(params{2});

if params{3}=='co';%deconvolution
    mode =1;
    kern_ord= str2double(params{6});
elseif params{3}=='dh';%inversion of the heat equation (difference approximation)
    mode =2;
     kern_ord=0;
elseif params{3}=='ch';%inversion of the heat equation (collocation approximation)
    mode =2;
     kern_ord=0;
end

time_param = str2double(params{7});

noiseFactor = str2double(params{9});% STD of Gaussian noise

 % wavelet packet's order;

changeNoise = params{10};

%preparation of the orinal image 'bloch', blurred image 'cloch', noised blurred input 'Z', 
%  blurring kernel 'ker_nel', its DFT 'fker_nel' and additive noise

perm=0;
%blurring the  result array 

[bloch, cloch, Z,  fker_nel,ker_nel,nois,fnois] = buildInputFunctions_RMP( changeNoise, noiseFactor, time_param,  imageFileName,mode,kern_ord);
%
[Depth,w_coef,t_coef ]=wavs_theta_coefP(spl_ord,fker_nel,kern_ord);
w_coef=w_coef(2:end,:);t_coef=t_coef(2:end,:);
Depth
norm_t=tnorrP(t_coef,levels);
[~,O]=sort(norm_t(:,4),'descend');


list=norm_t(O,2:4);

[vt ~]=size(list)
 list=[list (1:vt)'] ;
fZ=transpose(fft(Z));
band= str2double(params{8});
if band==0
    fnois_m=fnois;
    else 
%modelling noise
fnois_m=nois_model(fZ,band);
end    
[vn,hn]=size(fnois_m);
rn=randperm(vn);
[alpha_comb, ~, ~, ~, ~] =purs_optP(list, t_coef,fnois_m(rn(1),:), fZ(rn(1),:));
[al ial] =sort(abs(alpha_comb(:,1)),'descend');
mal=min(al);
figure(31);bar(al);title(['Oblique projection coefficients for  Theta waveforms, min=' num2str(mal)])
T1=input('Define threshold for stopping;0--former; ?')        
if T1>0
    T=T1;
end

fl=find(abs(alpha_comb(:,1))>T);
list=list(fl,:) 
 lsl=length(fl);
[sonorm,O]=sort(list(:,3),'descend');
if time_param==0
    T0=lsl;
else
figure(33);bar(sonorm);title('Sorted norms of Theta waveforms')
 T10=input('Define number of Theta waveforms to involve;0--former; ?')
if T10>0
    T0=T10;
end
end
list=list(1:T0,:);

iter = str2double(params{5});
tic
CF=[];OR=[];
conv_func=[];result2=[];ITE=[];
decreg2=[];decwin2=[];
RHO=[];

tic
for kk=1:hn
    fN=fnois_m(kk,:);

   %regularized matching pursuit of the kk column of the array Z
    [conv_func1, result1,  ite] = rm_pursP(fZ(kk,:), spl_ord,kern_ord, iter,w_coef, t_coef, list,T,fN,fker_nel);

result2=[result2 result1'];
conv_func=[conv_func; conv_func1];

[kk;ite]
 
ITE=[ITE ite];
end
toc
result=result2.*(result2>0).*(result2<=255)+255*(result2>255);
conv_func=conv_func';


D_rmp_displayP(hn,bloch,Z,result)
% Copyright (c) 2013. Valery A. Zheludev 