function [approx_conv_func, result,  ite] = rm_pursP(fploch, spl_ord,ord_ker, iter,w_coef, t_coef, list,T,fnois,fker_nel)

%regularized matching pursuit of the 1D signal 'ploch' whose DFT is 'fploch'
%spl_ord--order of spline wavelet packets
%ord_ker --order of spline interpolating the blurring kernel (for deconvolution)
%iter-- maximal number of iterations
%w_coef--SHA spectrum of the  wavelet packets from the approximation dictionary
%t_coef--DFT spectrum of the  waveforms 'Theta' from the testing dictionary
%list-- list of participants in the dictionaries 
%T -- threshold for stopping rule
%fnois -- DFT of estimated noise
%fker_nel--  DFT of  the blurring kernel 
%ite--actual number of iterations
%result -- result of matching pursuit
%approx_conv_func -- result of matching pursuit convolved with the blurring kernel
N=length(fploch);
 j=log2(N);
%n = 0:(N-1);
[u1,~]=juviP(spl_ord,N);
[upq,~]=juviP(spl_ord+ord_ker,N);
[uq,~]=juviP(ord_ker,N);
[u2,~]=juviP(2*spl_ord,N);
V=u1./sqrt(u2);
%V=juV(spl_ord,j)./sqrt(juV(2*spl_ord,j));
Q=upq./sqrt(u2)./(uq);
% 	nn=pi*(n)/N;
% 	mw=exp(i*2* nn);
sigma_app=0;FT_remainder=fploch;
[vt ht]=size(list);
for kk=1:iter
if vt>0
    %calculation of the oblique projection coefficients 'alpha_comb' of the
%remainder for waveforms listed in 'list' 
%finding an optimal waveform, located at  'level_opt, block_opt', whose coefficient is  'alpha_max_max'
%its shift is determined by 'ekm'
%lambda --optimal slope

%calculation of the oblique projection coefficients
    [alpha_comb, lambda, level_opt, block_opt , ekm] =purs_optP(list, t_coef,fnois, FT_remainder);


fl=find(abs(alpha_comb(:,1))>T);
%abs(alpha_comb)
%
list=list(fl,:);
%update of the SHA spectra of approximating splines
sigma_app=sigma_app+lambda*w_coef{level_opt}{block_opt}.*ekm;
%update of the DFT of remainder
FT_remainder=FT_remainder-lambda*t_coef{level_opt}{block_opt}.*ekm;

[vt ht]=size(list);


else
    break
end

end
    ite=kk;
result=real(ifft(sigma_app.*V));
approx_conv_func=real(ifft(sigma_app.*fker_nel.*Q));
