%GensplConsPF_examp
%Comparison of interpolating and smoothing generators of spline spaces and their SHA spectra

    lole=8;
    N=2^lole;

Ll=3;
    M=N*2^Ll;


    Par=[2 4 8 12];

Rho=.1*ones(1,4)

SP=[];fSP=[];
SPi=[];fSPi=[];
for kk=1:4
    P=Par(kk);
    rho=Rho(kk);
[spli fspli]=spligenPF(6,P,N,Ll,rho);
SP=[SP;spli];
fSP=[fSP;fspli];
[ispli ifspli]=spligenPF(1,P,N,Ll,rho);
SPi=[SPi;ispli];
fSPi=[fSPi;ifspli];
end
x=(1:M)-M/2;y=x/2^Ll;

figure;
for kk=1:4
eval(['subplot(4,2,' int2str(2*kk-1) ')'])

a=[SP(kk,:) ];
plot(y,a,'LineWidth',3);
hold on
a=[SPi(kk,:) ];
plot(y,a,'--','LineWidth',3);

% 
ma=min(a);Ma=max(a);
axis([-16 16 ma-.1 Ma+.1])

end
%figure;
for kk=1:4
eval(['subplot(4,2,' int2str(2*kk) ')'])
a=fSP(kk,:);

plot(a,'LineWidth',3);
hold on
a=fSPi(kk,:);

plot(a,'--','LineWidth',3);
     title(['\fontsize{16}Spline order: '  int2str(Par(kk))])

ma=max(a);
%   
axis([0 2*N  0 ma+.1])
set(gca,'XTick',0:N/2:2*N)
set(gca,'XTickLabel',{'-N','-N/2','0','N/2','N'})
%set(gca,'XTickLabel',{'0','N/4','N/2'})
% end
% %hold on
 end
