function [u,v]=juviP(Par,N)
%u --characteristic sequence of the space of 'N'-periodic splines of order
%'Par' (DFT of the  B-spline sampled at integer points)
%v --DFT of the  B-spline sampled at semi-integer points

load BSUV% samples of the  B-splines
if Par==0
    Par=1;
end
V=BSUV{Par,2}{1};lv=BSUV{Par,2}{2};
U=BSUV{Par,1}{1};lu=BSUV{Par,1}{2};
%N=2^j;
u=abs(fft(U,N))/lu;
v=abs(fft(V,N))/lv;
nu=floor(N/2);
v((nu+1):N)=-v((nu+1):N);