function y = rshuk(k,x,ex)
% k-sample right shift of  m,n matrix
%ex=3 --shift using extension symmetric about -1/2
   %example: 
    %x=1:5;k=2;ex=3;y = rshuk(k,x,ex)
%y =      2     1     1     2     3
%ex=2 -- shift using extension symmetric about 0
      %example: 
    %x=1:5;k=2;ex=2;y = rshuk(k,x,ex)
%y =     3     2     1     2     3
%ex=1 -- circular shift
      %example: 
    %x=1:5;k=2;ex=1;y = rshuk(k,x,ex)
%y =     4     5     1     2     3
% ex=7 -- shift using zero pad 
    %example: 
    %x=1:5;k=2;ex=7;y = rshuk(k,x,ex)
%y =      0     0     1     2     3    
% ex=8 -- shift using extrapolation by quadratic polynomial 
%example: 
    % x=(1:5).^2;k=2;ex=8;y = rshuk(k,x,ex)
%y =      1     0     1     4     9  

if k<0
y = lshuk(-k,x,ex);
else

[m,n] = size(x);
if ex==3
   y = [ x(:,k :-1:1) x( :,1: (n-k) )];
   elseif ex==2
      % 
      y = [ x(:,k+1:-1:2) x( :,1: (n-k) )];%
   elseif ex==1
      y = [ x(:,n-k+1:n) x( :,1: (n-k) )];%
 elseif ex==7
       y = [ zeros(m,k) x( :,1: (n-k) )];%
 
      elseif ex==8%
          [v,h]=size(x);
          K=[];o=ones(v,1);
      for kk=-k+1:0
          f=parab(o,2*o,3*o,x(:,1),x(:,2),x(:,3),kk);
          K=[K,f];
      end
      %K
      y = [K, x( :,1: (n-k) )];
end

end
%%%%%%%%%%%%%%%
    function f=parab(x1,x2,x3,f1,f2,f3,x)
       f=f1.*(x-x2).*(x-x3)./(x1-x2)./(x1-x3)+f2.*(x-x1).*(x-x3)./(-x1+x2)./(x2-x3)...
           +f3.*(x-x2).*(x-x1)./(x3-x2)./(-x1+x3);