function x=List_synthP(wctran,ListBB,Par)
%reconstruction of 1D row signal 'x' or a set of row signals 
%from the coefficients in the discrete-time  wavelet packet basis,
%which is defined by 'ListBB' list. 
%'wctran' cell array  of all the wavelet packet transform coefficients

[vx,M]=size(wctran{1});
[De,GS]=wavs_coefP(Par,M);
[ve t]=size(ListBB);

sigma=0;
for kk=1:ve
    [lev]=ListBB(kk,1);
    [blo]=ListBB(kk,2);
    ww=wctran{lev+1}{blo+1};
    s=fft(ww,[],2);
s=repmat(s,1,2^(lev));

g=GS{lev+1}{blo+1};
g=repmat(g,vx,1);
sigma=sigma+s.*g;
end
x=real(ifft(sigma,[],2));
% Copyright (c) 2013. Valery A. Zheludev