function [wvtran, wctran, entro,ener]=spl_WP_analP(x,Par,DeTr)
%1D spline wavelet packet transform of a row signal or an array of row signals 'x'
%Par -spline order 
%DeTr--depth of transform
%x--input array
%wvtran --cell array of size (DeTr+1,1),where  cell #l (l=1:DeTr+1)contains the 
%coordinates in the wavelet packet basis from the level 'l-1', which are arranged according to their
%frequency content

%wctran -- cell array of size (DeTr+1,1),where  cell #l (l=1:DeTr+1)contains the coordinates
%in the wavelet packet basis  from the level 'l-1', where each block of coordinates
%occupies a separate subcell. Altogether cell #l comprizes 2^(l-1) subcells, which are labeled according to the  
%frequency content of the coefficients

% entro -- cell array of size (DeTr+1,1),where  cell #l (l=1:DeTr+1)contains the entropies in  2^(l-1)blocks 
%of coordinates from the level 'l-1'
% ener -- cell array of size (DeTr+1,1),where  cell #l (l=1:DeTr+1)contains the l2 norms of  2^(l-1)blocks 
%of coordinates from the level 'l-1'

[vx M]=size(x);

ny=norm(x(:));
fx=fft(x,[],2);
wvtran=cell(DeTr+1,1);
entro=cell(DeTr+1,1);
ener=cell(DeTr+1,1);
wctran=cell(DeTr+1,1);
wctran{1}=x;
wvtran{1}=x;
entro{1}=caenP(x,1,ny);%computation of the entropy
ener{1}=norm(x);



for kk=1:DeTr
    
   
    A=matr_transP(M,Par,vx,1);
   [wvt, wct, fwvt,ent, ene]=wP_downP(kk,M,fx,A,ny); 

  fx=fwvt;
  M=M/2;
 wvtran{kk+1}= wvt;
 entro{kk+1}= ent;
 ener{kk+1}= ene;
  wctran{kk+1}= wct;
  
end

%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2013. Valery A. Zheludev
