function [De,GS,Sam]=wavs_coefP(Par,M)

%M- length of fragments to be processed
%Par- order of spline

%De- maximal depth of decomposition


 
%computation of SHA spectra of the  wavelet packets of order Par on the fragment
%of length M down to the level De=(J-P), where J=log2(M), P=ceil(log2(2*Par-1))
%and wavelet packets
%GS- cell array of SHA spectra coefficients
%Sam -- cell array of grid samples of the wavelet packets

J=log2(M);
u=juviP(Par,M);
u2=sqrt(juviP(2*Par,M));
V=u./u2;
P=ceil(log2(2*Par-1));
De=J-P;
GS=cell(De+1,1);
Sam=cell(De+1,1);
GS{1}=cell(1,1);
g=ones(1,M);
GS{1}{1}=g;
Sam{1}=cell(1,1);
Sam{1}{1}=real(ifft(g.*V));
N=M;
for j=1:De;    
[s d ]= lohifilP(Par,N);
s=repmat(s,1,2^(j-1));
d=repmat(d,1,2^(j-1));
GS{j+1}=cell(1,2^j);
Sam{j+1}=cell(1,2^j);
for kk=1:2^(j-1);
R=rem(kk-1,2); 
g=GS{j}{kk};
sd=(1-R)*d+R*s;
ds=(1-R)*s+R*d;

GS{j+1}{2*kk-1}=g.*ds*sqrt(2);  
GS{j+1}{2*kk}=g.*sd*sqrt(2);  

Sam{j+1}{2*kk-1}=real(ifft(g.*ds*sqrt(2).*V));  
Sam{j+1}{2*kk}=real(ifft(g.*sd*sqrt(2).*V)); 

% kk
% j
end
N=N/2;
end


% Copyright (c) 2013. Valery A. Zheludev
 