function [fxe,fxo]=down_lif(fx,Par, pol_dis_qint);
%one step of direct biorthogonal wavelet transform 
%fx -DFT of input signal (or an array of row signals)
 %Par--spline order
% pol_dis_qint=1--polynom. interp. spline; =2--discr. interp. spline; =3--quasi-interp. spline 
%Par=33 --extended quadratic quasiinterp. spline
%fxe -DFT of low-frequency output  signal
%fx0 -DFT of high-frequency output  signal
[ve,lx]=size(fx); 

[wm,w,f]=slfilt_lif(lx/2,lx/2,Par,pol_dis_qint);

wm=repmat(wm,ve,1);
  w= repmat(w,ve,1);
 f=repmat(f,ve,1);
 
a=fx(:,1:lx/2);b=fx(:,lx/2+1:lx);
fxe=(a+b)/2;
fxo=w.*(a-b)/2;

fxo=fxo-f.*w.*fxe;

fxe=fxe+wm.*(f/2).*fxo;


% Copyright (c) 2013. Valery A. Zheludev