function [f,z, fker, q_n] = buildInputFunctions_BP(changeNoise, noiseFactor, time_param,  inputFile,conv_heat,Par)
%preparation of the orinal image 'f', noised blurred input 'z', 
% DFT of the blurring kernel 'fker' and additive noise 'q_n'
%if changeNoise == 'y' then new gaussian noise  array is produced whose
%magnitude is 'noiseFactor' 
%time_param -- STD for the convolution kernel or time for heat inversion 
% inputFile name of the inpur bmp file 
%conv_heat=1--deconv.;conv_heat=2--heat inversion with difference appr.;
%conv_heat=3--inversion with collocation appr.;
%Par -- order of involved splines

f =  imread(inputFile);

[N hf df]=size(f);
j=log2(N);
if df > 1
    f = rgb2gray(f);
end
f = double(f);
eta=1;



ff = fft2(f);


   if conv_heat==1 %deconvolution
    [~,fker] =buikerP(N,time_param,1);
   fz = ff.*fker;
   else
  [~,fk] =buikerP(N,time_param,5);
  fz = ff.*fk;
  s2=(2*sin(pi*(0:N-1)/N)).^(2);
if conv_heat==2%heat inversion -- difference approximation
eta=exp(-s2*time_param);

elseif conv_heat==3%heat inversion -- collocation approximation
    [u,~]=juviP(Par,N);
 [uq,~]=juviP((Par-2),N);  
  %eta=exp(-s2.*uq./(u)*time_param);
eta=exp(-s2*time_param.*uq./u);
%eta=exp(-s2*time_param);
end
fker=eta'*eta; 
   end
    
    z = real(ifft2(fz));%this is the clean blurred function
  
  load answerB_P parameters q_n;
  if(changeNoise == 'y' )
    q_n = randn(N,N);
    save answerB_P parameters q_n;
  end
  q_n = noiseFactor * q_n;
  z = z + q_n; %this is the noised convolved function 


end
% Copyright (c) 2013. Valery A. Zheludev