function [spline_f, spline_g, rho, max_norm_conv_wp] = onePacketDecon_PN( maxPos, fker, w_coef, fZ, fNoise,sc,W,T,V)
% partial solution in a subspace defined by maxPos
%w_coef --  SHA spectra of wavelet packets
%fZ --DFT of input
%fNoise -- DFT of noise
%fker -- DFT of blurring kernel
%%sc-- scaling of the regularization parameter
%rho-- regularization parameter derived by the function `defro_PN'
%max_norm_conv_wp-- maximal norm of the w. packets convolved with the
%blurring kernel
%spline_f -- partial spline solution in the subspace
%spline_g -- partial spline solution in the subspace convolved with the
%blurring kernel
[N,hz]=size(fZ);
 r = maxPos(1);
    mr = maxPos(2);
    mc = maxPos(3);
range_rho=[0 10000];
nu_pq_r = abs(w_coef{r}{mr});
%
nu_pq_c = abs(w_coef{r}{ mc});

%
nu_pq = (nu_pq_r' * nu_pq_c/2^r).^2;

fZ_nu = fZ .* nu_pq;

max_norm_conv_wp=max(max(abs(nu_pq.*fker)));

fNoise_nu = fNoise .* nu_pq;

sqr_epsilon=sum(sum(abs(fNoise_nu).^2))/N/hz;


try

ToX= 0.000000000001;
rho  =defro_PN(fZ_nu,fker,sqr_epsilon,W,T,range_rho,ToX);
catch ME
    rho = 0.1;
    
end

rho=rho*sc;

%partial Tikhonov solution in the subspace 
[spline_f, spline_g] = tikh_dec(fZ_nu,fker,rho,W,T,V);

end
% Copyright (c) 2013. Valery A. Zheludev 