function liss=sort_list_P(lis,fker,w_coef)
%sorting wavelet packets included in the Best Basis list `lis` according to the
%norms of their convolutions with the blurring kernel 
 [vli, hli]=size(lis);
 K=[];
 nor=zeros(vli,1);
 for kk = 1 :vli


    maxPos = lis(kk,1:3);
    r = maxPos(1);
    mr = maxPos(2);
    mc = maxPos(3);
nu_pq_r = abs(w_coef{r}{ mr});
%
nu_pq_c = abs(w_coef{r}{mc});

nu_pq =transpose(nu_pq_r) * nu_pq_c;

a=ifft2(nu_pq.*fker);
nor(kk)=norm(a(:));
 end
liss=[lis nor];
[m,pos]=sort(nor,'descend');
liss=liss(pos,:);