function [decon y] = tikh_dec(fZ, fker,  rho, W,T,V)
%decon --regularized  Tikhonov solution 
%y -- solution convolved with the kernel
%fZ--DFT of input
%fker --DfT of blurring kernel
%rho --regularization parameter
% 
[N,m]=size(fZ);
if m>1;
   W=W'+W; 
   T=T*T';
   V=V*V';
end       
 sigma=fZ.* conj(fker).*T./(eps+rho*W'+(abs(fker).*T).^2);
 if m==1
     decon=real(ifft(sigma.*V));
     y=real(ifft(sigma.*V.*fker));
 elseif m>1
     decon=real(ifft2(sigma.*V));
     y=real(ifft2(sigma.*V.*fker));
 end
 
 