function [uk1,dk1,bk1]=BREGMAN_INPAINT_DEBLU_hm(IND_noise,r1,dk,bk,ker,Ll,IND,mu,lambda,iter_c_grad,HMWF)
%a single Bregman iteration for the restoration of an image corrupted by
%blurring, addition of white noise and loss of a iter_c_grader of pixels
%IND_noise -- indices of missing pixels
% IND-- index of frame from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- iter_c_grader of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%mu,lambda-- parameters
%Ll-- depth of decomposition
%ker -- blurring kernel
%dk,bk -- auxiliary input  cell arrays 
%dk1,bk1 -- auxiliary output  cell arrays 
%HMWF -- cell array of the transform filters (produced by function 'hmwf.m')
%iter_c_grad number of the cohj. gradient iterations
%r1-- data array convolved with the conjugate kernel
%uk1 -- result of the Bregman iteration
DB=framinPb(dk,bk,-1);
r2=fram34_rec2d_hmwf(DB,Ll,IND,HMWF);



uk2=r1+mu*r2;

%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%conjugate gradient (CG) method
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

 uk1  = conjgradBP(ker,IND_noise,mu,uk2,zeros(size(uk2)),iter_c_grad); 
 

vv1=fram34_dec2d_hmwf(uk1,Ll,IND,HMWF);

fx=lambda/mu;

dk1=fram_threPb(framinPb(vv1,bk,1),fx );

vk=framinPb(vv1,dk1,-1); 

bk1=framinPb(bk,vk,1); 

