  function y = conjgradBP_1d(ker,IND_noise,mu,b,y0,iter_c_grad)
  %1D conjugate gradient solver
  %y-- output image
  %iter_c_grad --number of iterations
  %mu --parameter
  %IND_noise -- indices of missing pixels
  y=y0;
  A_y=operator(y,ker,IND_noise,mu);
 
    r=b-A_y;%r=b-A*x;

    p=r;
  
 rsold=sprod(r,r);
 
    for i=1:iter_c_grad
        Ap=operator(p,ker,IND_noise,mu);
        alpha=rsold/(sprod(p,Ap)+eps);
        y=y+alpha*p;
        r=r-alpha*Ap;
        rsnew=sprod(r,r);
        [i rsnew];
        if  rsnew <1e-10
              break;
        end
        
        p=r+(rsnew/ rsold+eps)*p  ;
        rsold=rsnew;
    end
    
    
%end
% %%%%%%%%%%%%%%%%%%%
function a=sprod(b,c)
a=b(:)'*c(:);
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function A=operator(X,B,IND_noise,mu)
A=[];
  A2=conv(X,B,'same') ;
A2(IND_noise)=0;
A2=conv(A2,B','same') ;

A=mu*X+A2;

