function eta=ETTA_P(Par,M,e_time,dif_col,dim)

% coefficients for inversion of the  heat equation
% M --size of the array
%e_time-- evolution time
%dim-- dimension of the array
%dif_col=1 -- collocation approximation
%dif_col==2 -- difference approximation
if nargin<5
    dim=2
end
[u,~]=juviP(Par,M);

 [uq,~]=juviP((Par-2),M); 
s2=(2*sin(pi*(0:M-1)/M)).^(2);
if dif_col==2%difference approximation
eta=exp(-s2*e_time);

elseif dif_col==1%collocation approximation
  eta=exp(-s2.*uq./u*e_time);

end
if dim==2
eta=eta'*eta;
end