%
function [spli, fspli]=conv_splaP(x,Par,q,mu,Ll,rho) 
%Spline-based Tikhonov deconvolution
%x --samples of an input signal at integer points {n=0:N-1}, N=2^j 
%the input signal is blurred with a kernel and/or corrupted by noise, 
%mu -- coordinates of the blurring kernel in the basis of  exponential splines of
%order 'q'
%Par -- order of solution spline, should be even number
%rho -regularization parameter
%Ll -- depth of binary subdivision 
%calculation of the spline values 'spli'at dyadic rational points {n/2^Ll}
%fspli-- FGT of the array 'spli'
lx=length(x);
Y=fft(x);
 [u,~]=juviP(Par,lx);
 %[u2,~]=juviP(2*Par,lx);

 [urq,~]=juviP((Par+q),lx); 
 
n=0:lx-1;
    s=(2*sin(pi*n/lx)).^Par;
   
  
W=u.*(s);
A=rho*W+(abs(mu.*urq)).^2;
PH=conj(mu).*urq.*u.*Y;
x=real(ifft(PH./A));
 if Ll>0   
[spli]=intersplliPt(x,Par,Ll,2);
else
     spli=x;
     
 end



fspli=abs(fft(spli));

%  %
%  % Copyright (c) 2011. Valery A. Zheludev




