%
function [spli, fspli]=convsplaP2(x,Par,q,mu,Ll,rho)  
%Spline-based 2D Tikhonov deconvolution
%x --samples of the input array at integer points {k,n=0:N-1}, N=2^j
%the input array is blurred with a kernel and/or corrupted by noise, 
%mu -- coordinates of the blurring kernel in the basis of 2D exponential splines of
%order 'q'
%Par -- order of 2D solution spline, should be even number
%rho -regularization parameter
%Ll -- depth of binary subdivision 
%calculation of the spline values 'spli'at dyadic rational points {n/2^Ll}
%fspli-- 2D FGT of the array 'spli'


[lx,~]=size(x);
Y=fft2(x);
 
 [u,~]=juviP(Par,lx);
 [u2,~]=juviP(2*Par,lx);

 [urq,~]=juviP((Par+q),lx); 
 urq=urq'*urq;

n=0:lx-1;
   s=(2*sin(pi*n/lx)).^Par;
  
W=u2'*(s.*u);

   W2=W'+W;
   u2=u2'*u2;
   u=u'*u;
A=rho*W2+(abs(mu.*urq)).^2;
PH=conj(mu).*urq.*u.*Y;
    x=real(ifft2(PH./A));
 if Ll>0   
[spli]= intersplli2DPt(x,2,Par,Ll,2,Par,Ll) ; 
 else
     spli=x;
     %gri=1:lx;
 end

fspli=abs(fft2(spli));
 %



% % Copyright (c) 2011. Valery A. Zheludev
% 



