%
function [sp, fsp, samp_sp ]=D_gen_cons(period,span,order,type)
%design of the discrete spline generators `sp`, their DFT `fsp` and
%sampling `samp_sp` on the sparse grid 
%type=0 --  B-sp
%type=1 -- dual to B-sp
%type=2 -- fundamental sp
%type=3 -- self-dual sp
N=period;
m=span;
P=order;

[~, fbsp, ~, U]=per_dbspP(N,m,P);
[~, ~, ~, U2]=per_dbspP(N,m,2*P);
%[ U2]=per_dspUP(N,m,2*P);
a=2^m;
U=repmat(U,1,a);
U2=repmat(U2,1,a);
if type==1
fsp=  fbsp./U2;  
elseif type==0
fsp=  fbsp;  
elseif type==2
fsp=  fbsp./U;  
 elseif type==3
fsp=  fbsp./sqrt(U2);  
end   
    
sp=real(ifft(fsp));
samp_sp=sp(1:2^m:end);

 % Copyright (c) 2013. Valery A. Zheludev