function [x, sigma ]=D_List_synthP(wctran,ListBB,Par)
%reconstruction of 1D row signal 'x' or a set of row signals 
%from the coefficients in the discrete spline  wavelet packet basis,
%which is defined by 'ListBB' list. 
%wctran -- cell array  of all the wavelet packet transform coefficients

%sigma--DFT spectrum of the signal
[vx,M]=size(wctran{1});
De=max(ListBB(:,1));
[GS]=D_wP_coefP(Par,M,De);
[ve t]=size(ListBB);

sigma=zeros(vx,M);
for kk=1:ve
    [lev]=ListBB(kk,1);
    [blo]=ListBB(kk,2);
    ww=wctran{lev+1}{blo+1};
    s=fft(ww,[],2);
s=repmat(s,1,2^(lev));

g=GS{lev}{blo+1};
g=repmat(g,vx,1);
sigma=sigma+s.*g;
end
x=real(ifft(sigma,[],2));
% Copyright (c) 2013. Valery A. Zheludev