function [x, sigma]=D_List_synthP_2D(wctran,ListBB,Par)
%reconstruction of 2D signal 'x' from the coefficients in the  wavelet packet basis, which is defined by 
% 'ListBB' list. 
%'wctran' cell array  of all the wavelet packet transform coefficients

%'sigma'--DFT spectrum of the signal x

[~,M]=size(wctran{1});
De=max(ListBB(:,1));

[GS]=D_wP_coefP(Par,M,De);
[ve t]=size(ListBB);

sigma=0;
for kk=1:ve
    [lev]=ListBB(kk,1);
    [blov]=ListBB(kk,2);
    [bloh]=ListBB(kk,3);
    ww=wctran{lev+1}{blov+1,bloh+1};
    s=fft2(ww);
s=repmat(s,2^(lev),2^(lev));

gv=GS{lev}{blov+1};
gh=GS{lev}{bloh+1};

g=transpose(gv)*gh;
sigma=sigma+s.*g;
end
x=real(ifft2(sigma));

% Copyright (c) 2013. Valery A. Zheludev