 
function A=D_matr_transP(N,Par,vx,span,si)

%A--discrete spline wavelet packet transform matrix 
%Par--spline order
%vx--number of rows
%si=1 --direct transform
%si=-1 --inverse transform

[S D ]= D_lohifil_RP(Par,N,span);

n=0:N-1;
S=repmat(S,vx,1);
D=repmat(D,vx,1);
    

[S0 S1]=havshB(S);
[D0 D1]=havshB(D);

  if si==1
  A={S0 S1;conj(D0) conj(D1)};
  
elseif si==-1
  A={S0 D0;S1 D1};
  end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [s d ]= D_lohifil_RP(Par,N,span)
 %low-and high-pass filters for   wavelet packet transforms 
m=span;
Nm=N/2^(m-1);
	n=0:(Nm-1);
	nn=pi*(n)/Nm;
	mw=exp(-i*2* nn);
    bc=(cos(nn)).^Par;
    
   [~, ~, ~, u1]=per_dbspP(N,(m),2*Par);
   u1=repmat(u1,1,2);
    [~, ~, ~, uc]=per_dbspP(N,(m-1),2*Par);
   
  s=sqrt(uc./2./(u1+eps)).*bc;
    
    d= circ_h(s,Nm/2).*(mw);
    
% Copyright (c) 2013. Valery A. Zheludev