function [wvrec]=D_wav_syntP(wvtran,Par,DeTr)
%1D  synthesis of a row signal or a set of row signals 'x'
%from the  set 'wvtran' of the discrete spline wavelet transform coefficients
%Par -- spline order
%DeTr -depth of decomposition

%wvrec --restored array
[vx,N]=size(wvtran);

M=N/2^(DeTr-1);



for kk=1:DeTr
    m=1:M;
n=m-1;
q=wvtran(:,m);
[lo, hi]=havshB(q);
lo=fft(lo,[],2);
hi=fft(hi,[],2);

 A= D_matr_transP(N,Par,vx,DeTr-kk+1,-1);  
 
  lo0=(A{1,1}.*lo+A{1,2}.*hi)*sqrt(2);
 lo1=(A{2,1}.*lo+A{2,2}.*hi)*sqrt(2);
  wvtran(:,m)=real(ifft([lo0 lo1],[],2));
  
  M=M*2;
end
wvrec=(wvtran);
% Copyright (c) 2013. Valery A. Zheludev