function [Fd,Wd,Fr,Wr]= FW3_P(lv,N, Par,TS)
%preparation of  filters for one step of a 3-channel frame transform
%lv--number of row signals of length 'N' to be transformed

% Par-- spline order; 
%TS=0--tight frame, otherwise -- semi-tight frame
sq=sqrt(2);
sr=sqrt(3);

n=0:(N-1);
w=exp(2*pi*i*n/N);
wm=exp(-2*pi*i*n/N);
w=repmat(w,lv,1);
wm=repmat(wm,lv,1);
rho=w+2+wm;
     rhon=-w+2-wm;

if Par==1%linear spline
    Fd=(1+wm.^1)/2;
    Wd=(1-wm.^1)/sq;
    Fr=(1+w.^1)/2;
    Wr=(1-w.^1)/sq;
 %int2str(n/2)
   
elseif Par==2%quadratic interp. spline
  U=w+6+wm;
   Fd=4*(1+wm)./U;
   Fr=4*(1+w)./U;
   if TS==0
   Wd=(w-2+wm)./U*sq;
   Wr=(w-2+wm)./U*sq;
   elseif TS==1
  Wd=(w.^2-4.*w+6-4.*wm+wm.^2)./U/sq;     
   
  Wr=2./U/sq;     
   end
elseif Par==3%cubic interp. spline
    q=7-4*sqrt(3);
U= w.^1+4+wm.^1;   
G= -w.^1+14-wm.^1;   
  Fd=(wm.^2+23*wm+23+w)/8./U;
   Fr=(w.^2+23*w+23+wm)/8./U;

  if TS==0%non-symmetric  factorization (tight frame)
   Wd=(w.^1-2+wm.^1)/8./U.*( 1-q*wm.^1)*sq/sqrt(q);
   Wr=(w.^1-2+wm.^1)/8./U.*( 1-q*w.^1)*sq/sqrt(q);
 
  elseif TS==1%symmetric IIR factorization
   %W=(w.^2-2+wm.^2)/8./U*sq;
 Wd=(w.^1-2+wm.^1)/2./U*sq;
 Wr=(w.^1-2+wm.^1)/32./U.*G*sq; 
   elseif TS==2%symmetric FIR factorization
  Wd=(w.^1-2+wm.^1)/4*sq;
  Wr=(w.^1-2+wm.^1)/16./U.^2.*G*sq; 
   elseif TS==3%antisymmetric IIR factorization
   %W=(w.^2-2+wm.^2)/8./U*sq;
 Wd=(wm.^2-3*wm+3-w)./U/4*sq;%*3;
 Wr=(1-w)/16./U.*G*sq;%/3; 
  end 
 
  elseif Par==7%quadratic  quasiinterp. spline
    q=7-4*sqrt(3);
  
G= -w.^1+14-wm.^1;   
  Fd=(-wm.^2+9*wm.^1+9-w.^1)/16;
   Fr=(-w.^2+9*w.^1+9-wm.^1)/16;

  if TS==0%non-symmetric  factorization
   Wd=(w.^1-2+wm.^1)/16.*( 1-q*wm.^1)*sq/sqrt(q);
   Wr=(w.^1-2+wm.^1)/16.*( 1-q*w.^1)*sq/sqrt(q);

  elseif TS==1%symmetric factorization
   %W=(w.^2-2+wm.^2)/8./U*sq;
 Wd=(w.^1-2+wm.^1)/4*sq;
  Wr=(w.^1-2+wm.^1)/64.*G*sq;
 
  
   elseif TS==2%antisymmetric factorization
  
 Wd=(wm.^2-3*wm+3-w)/8*sq;
  Wr=(1-w)/32.*G*sq;
  elseif TS==3%symmetric factorization (all vm in analysis filter)
%    %W=(w.^2-2+wm.^2)/8./U*sq;
  Wd=(wm.^2-4*wm+6-4*w+w.^2)/16*sq;
  Wr=G*sq/16;    

  end 
 elseif Par==8%discrete  spline of order 8
     
   U=w.^2+28*w+70+wm.^2+28*wm;
   Fd=8*(1+wm).*(w.^1+6+wm.^1)./U;
   Wd=(w-2+wm).^2./U*sq;
   Fr=8*(1+w).*(w.^1+6+wm.^1)./U;
   Wr=(w-2+wm).^2./U*sq; 
   elseif Par==6%discrete  spline of order 6
     
   U=3*w+10+3*wm;
   Fd=(1+wm).*(w.^1+14+wm.^1)./U/2;
   Fr=(1+w).*(w.^1+14+wm.^1)./U/2;

   if TS==0
   Wd=(w-3+3*wm.^1-wm.^2)./U/sq;
    Wr=(wm-3+3*w.^1-w.^2)./U/sq; 
  elseif TS==1
      Wd=(w.^2-4*w +6-4*wm.^1+wm.^2)./U/2;
      Wr=(-wm+2-w)./U;%/sq;

   end
elseif Par==12%discrete  spline of order 12
     
   U=w.^3+66*w.^2+495*w+924+wm.^3+66*wm.^2+495*wm;
   Fd=4*(1+wm).*(w.^1+14+wm.^1).*(3*w+10+3*wm)./U;
   Wd=(w-2+wm).^3./U*sq;
    Fr=4*(1+w).*(w.^1+14+wm.^1).*(3*w+10+3*wm)./U;
   Wr=(w-2+wm).^3./U*sq;
end
    end

% Copyright (c) 2012. Valery A. Zheludev