function pctran=fram34_dec_hm(x,DeTr,IND,pd)
%3 or 4 -channel frame decomposition of a signal or an array of row signals 'x'
%DeTr-- depth of decomposition
% IND-- index of frame from the lists given in the scripts
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%if pd==-1 -- swap synthesis and analysis band-pass filters

%pctran--cell array of the transform coefficients

Par=IND(2);
TS=IND(3);

[~,lh]=size(x);


if nargin<4
    pd=1;
end 
no_channel=IND(1);

[~, hp]=size(x);
pctran=cell(DeTr,no_channel);
x1=x;

for kk=1:DeTr
   % N=lh/2;
if no_channel==3
    [x1, h,s]= fram3_down_hm(x1,IND,pd);
pctran{kk,3}=h;
pctran{kk,2}=s;
 elseif no_channel==4

    [x1, h, s2, s3]= fram4_down_hm(x1,IND,pd);

pctran{kk,2}=h;
pctran{kk,3}=s2;
pctran{kk,4}=s3;
end
%lh=lh/2;
end
pctran{kk,1}=x1;
% Copyright (c) 2013. Valery A. Zheludev