function pctran=fram34_dec_hmwf(x,DeTr,IND,HMWF,pd)
%3 or 4 -channel frame decomposition of a signal or an array of row signals 'x'
%DeTr-- depth of decomposition
% IND-- index of frame from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%HMWF -- cell array of the transform filters (produced by function 'hmwf.m')
%if pd==-1 -- swap synthesis and analysis band-pass filters

%pctran--cell array of the transform coefficients

[~ ,lh]=size(x);


if nargin<5
    pd=1;
end 
no_channel=IND(1);

[~, hp]=size(x);
pctran=cell(DeTr,no_channel);
x1=x;

for kk=1:DeTr
    hh=HMWF{kk};
    %N=lh/2;
if no_channel==3
   F=hh{1,1};
    W=hh{1,2}; 
    if pd==-1
        F=hh{1,3};
    W=hh{1,4}; 
    end
    [x1, h, s]= fram3_down_hmwf(x1,F,W);
pctran{kk,3}=h;
pctran{kk,2}=s;
elseif no_channel==4
    
    H=hh{1,1};
    M=hh{1,3};
     
if pd==-1
    H=hh{1,2};
    M=hh{1,4};
end
    [x1, h, s2, s3]= fram4_down_hmwf(x1,H,M);

pctran{kk,2}=h;
pctran{kk,3}=s2;
pctran{kk,4}=s3;
end
lh=lh/2;
end
pctran{kk,1}=x1;
% Copyright (c) 2013. Valery A. Zheludev