function x=fram34_rec2d_hm(pctran,DeTr,IND,pd)
%3 or 4 -channel frame reconstruction of a 2D array 'x'
%pctran--cell array of the transform coefficients
%DeTr-- depth of decomposition
% IND-- index of frame from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%if pd==-1 -- swap synthesis and analysis band-pass filters


no_channel=IND(1);
if nargin<4
    pd=1;
end 
x=pctran{DeTr}{1,1};

for kk=DeTr:-1:1
    Lev=pctran{kk};
   if no_channel==3 
    l=x';h=Lev{2,1}';s=Lev{3,1}';
 L=fram3_up_hm(l, h, s,IND,pd)';
  l=Lev{1,2}';;h=Lev{2,2}';s=Lev{3,2}';  
  H=fram3_up_hm(l, h, s,IND,pd)';  
    l=Lev{1,3}';;h=Lev{2,3}';s=Lev{3,3}';  
  S=fram3_up_hm(l, h, s,IND,pd)';  
 x= fram3_up_hm(L, H, S,IND,pd);
   elseif no_channel==4
     l=x';h=Lev{2,1}';s2=Lev{3,1}';s3=Lev{4,1}';
 L=fram4_up_hm(l, h, s2, s3,IND,pd)';
  l=Lev{1,2}';;h=Lev{2,2}';s2=Lev{3,2}';s3=Lev{4,2}';  
  H=fram4_up_hm(l, h,  s2, s3,IND,pd)';    
    l=Lev{1,3}';;h=Lev{2,3}';s2=Lev{3,3}'; s3=Lev{4,3}'; 
  S2=fram4_up_hm(l, h,  s2, s3,IND,pd)';    
    l=Lev{1,4}';;h=Lev{2,4}';s2=Lev{3,4}'; s3=Lev{4,4}'; 
  S3=fram4_up_hm(l, h,  s2, s3,IND,pd)';
 x= fram4_up_hm(L, H, S2,S3,IND,pd);
end
end

% Copyright (c) 2013. Valery A. Zheludev