function x= fram3_up_hm(l1, h, s,IND,pd)
%one step of 3-channel frame reconstruction of a signal or a set of row signals 'x'

% IND-- index of frame from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%if pd==-1 -- swap synthesis and analysis band-pass filters

%l1, h, s --the low-, high- and band-pass transform coefficients

sq=sqrt(2);
le=(l1+h)/sq;
Par=IND(2);
TS=IND(3);
 [lv,N]=size(h);
 n=0:(N-1);

lh=l1-h;
flh=fft(lh,[],2);

fs=fft(s,[],2);



[~,~,F,W]= FW3_P(lv,N, Par,TS);
if pd==-1
[F,W,~,~]= FW3_P(lv,N, Par,TS);
end
flo=(F.*flh+W.*fs)/sq;
lo=real(ifft(flo,[],2));
x=zeros(lv,2*N);
x(:,1:2:end)=le;
x(:,2:2:end)=lo;
 
% Copyright (c) 2012. Valery A. Zheludev