function [l1, h, s2, s3]= fram4_down_hm(l,IND,pd)
%one step of 4-channel frame decomposition of a signal or an array  of row signals 'l'

% IND-- index of frame from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%if pd==-1 -- swap synthesis and analysis band-pass filters

%l1, h --the low-, high-pass transform coefficients
%s2 and s3--the  band-pass transform coefficients




Par=IND(2);
TS=IND(3);
[lv, lh]=size(l);
N=lh/2;
[e o]=evod(l);
fe=fft(e,[],2);
fo=fft(o,[],2);
[H,~, M, ~ ] = HM4_P( Par,TS,N,lv);
if pd==-1
    [~,H, ~ , M] = HM4_P( Par,TS,N,lv);
end

fl1=fe.*H{1,1}+fo.*H{1,2};
   fh=fe.*H{2,1}+fo.*H{2,2};
  l1=real(ifft(fl1,[],2)); 
 h=real(ifft(fh,[],2));

fs2=fe.*M{1,1}+fo.*M{1,2};
fs3=fe.*M{2,1}+fo.*M{2,2};
    s2=real(ifft(fs2,[],2));
s3=real(ifft(fs3,[],2));
% Copyright (c) 2013. Valery A. Zheludev
