function x= fram4_up_hmwf(l1, h, s2, s3, H,M)
%one step of 4-channel frame reconstruction of a signal or a set of row signals 'x'

%H and M --transform filters (produced by function 'hmwf.m')
%l1, h --the low-, high-pass transform coefficients
%s2 and s3--the  band-pass transform coefficients



fl=fft(l1,[],2);
fh=fft(h,[],2);
fs2=fft(s2,[],2);
fs3=fft(s3,[],2);


     fle=fl.*H{1,1}+fh.*H{1,2}+fs2.*M{1,1}+fs3.*M{1,2};
flo=fl.*H{2,1}+fh.*H{2,2}+fs2.*M{2,1}+fs3.*M{2,2};

lo=real(ifft(flo,[],2));
le=real(ifft(fle,[],2));
[lv N]=size(le);
x=zeros(lv,2*N);
x(:,1:2:end)=le;
x(:,2:2:end)=lo;
 
% Copyright (c) 2013. Valery A. Zheludev