function [bloch,cloch, Z,fker_nel, ker_nel,nois,fnois] = buildInputFunctions_RMP( changeNoise, noiseFactor, time_param,  inputFile,mode,kern_ord)
%preparation of the orinal image 'bloch', blurred  image 'cloch', noised blurred input 'Z', 
% DFT of the blurring kernel 'fker_nel' and additive noise 'nois'
%if changeNoise == 'y' then noise is changed, otherwise it is retained
%noiseFactor-- STD of noise vectors
%time_param--STD of gaussiam kernel, evolution time for heat inversion
%if mode==1 --convolution with Gaussian kernel, kern_ord --order of spline
%interpolating the kernel (typically kern_ord=2)
%if mode==2 --heat equation with difference approximation
%if mode==3--heat equation with collocation  approximation

f =  imread(inputFile);
%f=f(1:2:512,1:2:512);
[ln, hn, df]=size(f);

if df > 1
    f = rgb2gray(f);
end
bloch = double(f);

 fbloch=transpose(fft(bloch)); 



[ker_nel, fker_nel ]=build_kernP(mode,ln,time_param,kern_ord);
fcloch=(repmat(fker_nel,hn,1)).*fbloch;
cloch=real(ifft(fcloch,[],2))';
clear fcloch
  load answerMP_P parameters nois;
  if(changeNoise == 'y' || isempty(nois))
    nois=[];
    for kk=1:hn
    %nois=[nois sqrt(va)*randn(vc,1)];
    nois=[nois noiseFactor*randn(ln,1)];
    end
     
    save answerMP_P parameters nois;
  end
  
 fnois=transpose(fft(nois));
  Z = cloch + nois; %this is the noised convolved function
end

% Copyright (c) 2013. Valery A. Zheludev