function [ker_nel, fker_nel]=build_kernP(mode,ln,t,spl_ord)
%ker_nel sampled kernel for deconvolution (mode=1),  for inversion of heat
%equation with difference approximation (mode=2) or with collocation  approximation (mode=3)
%fker_nel DFT of the kernel
%ln-- length of signal
%t-STD for Gaussian kernel or dissipation time for inversion of heat equation
%spl_ord order of the spline
n=0:ln-1;
si=(2*sin(pi*n/ln)).^2;

if mode==1%convolution with Gaussian kernel
    if t>0
ker_nel=fspecial('gaussian',[1,ln],t);
    else
ker_nel=zeros(1,ln);
ker_nel(ln/2)=1;
    end
ker_nel=double(ker_nel);
ker_nel=circ_h(ker_nel,ln/2);
fker_nel=fft(ker_nel,[],2);
elseif mode==2%difference approximation
    
fker_nel=exp(-si*t);
ker_nel=real(ifft(fker_nel));
%ker_nel=circ_h(ker_nel,ln/2);
elseif mode==3%collocation  approximation
[u,~]=juviP(spl_ord,ln);  
[uu,~]=juviP(spl_ord-2,ln);  
fker_nel=exp(-si.*uu./u*t);
ker_nel=real(ifft(fker_nel));

end
