function [De,GS,Theta]=wavs_theta_coefP(Par,fker_nel,ordker_nel)

%M- length of fragments to be processed
%Par- order of spline

%De- maximal depth of decomposition
%fker_nel DFT of the kernel
%ordker_nel order of  spline interpolating  the kernel

 
%calculation of SHA spectra of  wavelet packets of order Par on the fragment
%of length M down to the level De=(J-P), where J=log2(M), P=ceil(log2(2*Par-1))

%GS- cell array of SHA spectra coefficients Theta -- cell array of DFT of testing waveforms 
M=length(fker_nel);
q=ordker_nel;
J=log2(M);
u=juviP(Par,M);
upq=juviP(Par+q,M);
uq=sqrt(juviP(2*q,M));

u2=sqrt(juviP(2*Par,M));
V=u./u2;
Q=upq./u2./uq;
P=ceil(log2(2*Par-1));
De=J-P;
GS=cell(De+1,1);
Theta=cell(De+1,1);
GS{1}=cell(1,1);
Theta{1}=cell(1,1);
g=ones(1,M);
GS{1}{1}=g;

Theta{1}{1}=g.*fker_nel.*Q;
N=M;
for j=1:De;    
[s d ]= lohifilP(Par,N);
s=repmat(s,1,2^(j-1));
d=repmat(d,1,2^(j-1));
GS{j+1}=cell(1,2^j);
Theta{j+1}=cell(1,2^j);
for kk=1:2^(j-1);
R=rem(kk-1,2); 
g=GS{j}{kk};
sd=(1-R)*d+R*s;
ds=(1-R)*s+R*d;

GS{j+1}{2*kk-1}=g.*ds*sqrt(2);  
GS{j+1}{2*kk}=g.*sd*sqrt(2);  

Theta{j+1}{2*kk-1}=g.*ds*sqrt(2).*fker_nel.*Q;  
Theta{j+1}{2*kk}=g.*sd*sqrt(2).*fker_nel.*Q; 

kk
j
end
N=N/2;
end


% Copyright (c) 2013. Valery A. Zheludev
 