function [spli]=spligenP(type_gen,Par,N,Ll,rho)
%design of a single generator of an even-order spline space
% type_gen type of generator
%Par -- spline order 
%N--length of interval
%Ll--number of subdivision steps
%rho--regularization parameter for smoothing spline 
 M=N*2^Ll;
if type_gen==4%Battle-Lemarie

 [u1,~]=juviP(Par,N);
   [u2,~]=juviP(2*Par,N);
    x=real(ifft(u1./sqrt(u2)));

elseif type_gen==1%interpolating
    x=zeros(1,N);
    x(1)=1;  

elseif type_gen==5%B-spline 
    [u1,~]=juviP(Par,N);
    x=real(ifft(u1));
    
elseif type_gen==2%dual to B-spline 
     [u1,~]=juviP(Par,N);
   [u2,~]=juviP(2*Par,N);
    x=real(ifft(u1./u2));
    
    
elseif type_gen==3%dual to interpolating
     [u1,~]=juviP(Par,N);
   [u2,~]=juviP(2*Par,N);
    x=real(ifft(u1.^2./u2));
    
 elseif type_gen==6%smoothing 
     [u1,~]=juviP(Par,N);
  
   n=0:N-1;
   si=sin(pi*n/N);
   W=(2*si).^Par;
    x=real(ifft(u1./(rho*W+u1)));
 

 
end
 [spli]=intersplliPt(x,Par,Ll,2);  %subdivision of the spline 
[e r]=max(abs(spli));
if type_gen==7
spli=circshift(spli',M/4-r)';
spl=circshift(spli',M/4+1)';
else
    spli=circshift(spli',M/2-r)';
spl=circshift(spli',M/2+1)';
end
